<?php

namespace Plenty\Modules\Order\Models;

use Illuminate\Database\Eloquent\Model;

class OrderEvent extends Model 
{

    protected $table = 'plenty_order_event';
    public $timestamps = true;
    protected $guarded = array('id');
    protected $fillable = array('orderId', 'ownerId', 'statusId', 'eventSourceId', 'message');
    protected $visible = array('id', 'orderId', 'ownerId', 'statusId', 'eventSourceId', 'message', 'createdAt');

    public function status()
    {
        return $this->belongsTo('OrderStatus', 'id', 'statusId');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'id', 'orderId');
    }

    public function source()
    {
        return $this->hasOne('EventSource', 'id', 'sourceId');
    }

    public function type()
    {
        return $this->hasOne('EventType', 'id', 'typeId');
    }

}